import { connect } from 'react-redux';
import { setDocumentData, setVerdictAndComment } from '../../domain/store/actions/solution';
import { setTaskError } from '../../domain/store/actions/ui';
import { fetchAddressUsecase } from '../../usecases/fetchAddressUsecase';
import { DocumentView } from './Document';

const mapStateToProps = (state, { documentType }) => {
    const { documents, formsData } = state.documents;
    const { scaleOptions, taskError, activeDocumentIndex, submitting } = state.ui;
    const { facts, isForeign } = state.input;
    const { solution } = state;
    const isImgValid = state.documents.images[documentType]?.isValid;

    return {
        formsData: formsData[documentType]?.data ?? {},
        fieldsData: documents[documentType]?.data ?? {},
        isVerified: documents[documentType]?.is_verified,
        verdicts: solution.verdicts[documentType],
        comment: solution.comments[documentType],
        facts: facts[documentType],
        scaleOptions,
        taskError,
        activeDocumentIndex,
        isForeign,
        submitting,
        isImgValid,
    };
};

const mapDispatchToProps = (dispatch, { documentType }) => ({
    onVerdictChange: (values) => dispatch(setVerdictAndComment(values)),
    onFieldsChange: (values) => dispatch(setDocumentData({ values, documentType })),
    resetTaskError: () => dispatch(setTaskError(null)),
    onAddressSearch: fetchAddressUsecase,
});

export const Document = connect(mapStateToProps, mapDispatchToProps)(DocumentView);
