import dayjs from 'dayjs';

const DATE_FORMAT = 'YYYY-MM-DD';

export const validateDate = (rule, value) => {
    if (!value) return Promise.resolve(); // field might be optional

    if (isNaN(new Date(value).getMonth())) {
        return Promise.reject(rule.message);
    }

    const date = dayjs(value, DATE_FORMAT);

    if (date.format(DATE_FORMAT) !== value && !date.isValid()) {
        return Promise.reject(rule.message);
    }

    if (
        rule.range &&
        ((rule.range.to && date.isAfter(dayjs(rule.range.to))) ||
            (rule.range.from && date.isBefore(dayjs(rule.range.from))))
    ) {
        return Promise.reject(rule.message);
    }

    return Promise.resolve();
};
export const validateRow = (rule, value) => {
    if (!value) return Promise.resolve(); // field might be optional
    if (value.length > rule.maxLength) {
        return Promise.reject(rule.message);
    }
    return Promise.resolve();
};
