/* eslint-disable camelcase */
import React, { useEffect, useRef, useState } from 'react';
import PropTypes from 'prop-types';
import { serviceLocator } from '../../infrastructure/serviceLocator';
import UsecaseRunError from '../../infrastructure/errors/UsecaseRunError';
import { translate } from '../../utils/translate';
import { DOCUMENT_TYPES } from '../../domain/documents';
import { Tabs, Form } from 'antd';
import { SolutionOutlined, FileProtectOutlined, SmileOutlined, IdcardOutlined, CarOutlined } from '@ant-design/icons';
import { Hint } from '../Utility/Hint';
import { Document } from '../Document';
import './Sidebar.less';

export const SidebarView = ({ activeDocumentIndex, setActiveDocumentIndex, documentTypes }) => {
    const sidebarRef = useRef(null);
    const [formInstances, setFormInstances] = useState([]);

    useEffect(() => sidebarRef.current.focus(), []);

    useEffect(() => {
        serviceLocator.validateAndCollect = async () => {
            try {
                await Promise.all(Object.values(formInstances).map(async ({ validateFields }) => validateFields()));
            } catch {
                throw new UsecaseRunError();
            }
        };

        return () => {
            serviceLocator.validateAndCollect = null;
        };
    }, [formInstances.length]);

    const handleFormChange = (_, { forms }) => {
        // FIXME: get rid of this after the query forms method gets added to provider in upstream rc-form
        if (!formInstances.length) {
            setFormInstances(forms);
        }
    };

    const handleTabChange = (activeKey) => setActiveDocumentIndex(Number(activeKey));

    const renderTabHeader = (documentId) => {
        let iconComponent;

        switch (documentId) {
            case DOCUMENT_TYPES.passportBio:
                iconComponent = <SolutionOutlined />;
                break;
            case DOCUMENT_TYPES.passportReg:
                iconComponent = <FileProtectOutlined />;
                break;
            case DOCUMENT_TYPES.selfie:
            case DOCUMENT_TYPES.passportSelfie:
            case DOCUMENT_TYPES.licenseSelfie:
                iconComponent = <SmileOutlined />;
                break;
            case DOCUMENT_TYPES.licenseFront:
                iconComponent = <IdcardOutlined />;
                break;
            case DOCUMENT_TYPES.licenseBack:
                iconComponent = <CarOutlined />;
        }

        return <Hint title={translate(documentId)}>{iconComponent}</Hint>;
    };

    const renderTab = (documentId, index) => (
        <Tabs.TabPane tab={renderTabHeader(documentId)} key={String(index)} forceRender={true}>
            <Document documentType={documentId} documentIndex={index} />
        </Tabs.TabPane>
    );

    return (
        <div className="sidebar" ref={sidebarRef} tabIndex={0}>
            <Form.Provider onFormChange={handleFormChange}>
                <Tabs
                    className="sidebar__tabs"
                    tabPosition="right"
                    activeKey={String(activeDocumentIndex)}
                    keyboard={false}
                    onChange={handleTabChange}
                >
                    {documentTypes.map(renderTab)}
                </Tabs>
            </Form.Provider>
        </div>
    );
};

SidebarView.propTypes = {
    activeDocumentIndex: PropTypes.number.isRequired,
    setActiveDocumentIndex: PropTypes.func.isRequired,
    documentTypes: PropTypes.arrayOf(PropTypes.oneOf(Object.values(DOCUMENT_TYPES))).isRequired,
};
