import { connect } from 'react-redux';
import { store } from '../../domain/store';
import { TaskPageLayoutView } from './TaskPageLayout';
import { getMediaLinksUsecase } from '../../usecases/getMediaLinksUsecase';
import { getDocumentsUsecase } from '../../usecases/getDocumentsUsecase';

const mapStateToProps = (state) => ({
    ...state.input,
});

// eslint-disable-next-line no-unused-vars
const mapDispatchToProps = () => {
    // it's okay to use non-recalculating state here, since these values are never changed after initialization
    const {
        secret,
        documentTypes,
        confidenceThresholds,
        availableFields,
        outdata,
        isCustomField
    } = store.getState().input;
    const { assignmentId, sandboxChannels } = store.getState().ui;

    return {
        preloadData: async () => {
            await getDocumentsUsecase({ secret, documentTypes, confidenceThresholds, availableFields, assignmentId, outdata, isCustomField });
            getMediaLinksUsecase({ secret, documentTypes });
        },
        assignmentId,
        sandboxChannels,
    };
};

export const TaskPageLayout = connect(mapStateToProps, mapDispatchToProps)(TaskPageLayoutView);
