import React from 'react';
import { useTranslation } from 'react-i18next';
import { Provider } from 'react-redux';
import { store } from '../../domain/store';
import { ConfigProvider } from 'antd';
import { TaskPageLayout } from '../TaskPageLayout';

export const TaskView = () => {
    const [, i18next] = useTranslation();

    return (
        <ConfigProvider locale={i18next.antdLocale} componentSize="middle">
            <Provider store={store}>
                <TaskPageLayout />
            </Provider>
        </ConfigProvider>
    );
};
