import React from 'react';
import PropTypes from 'prop-types';
import { Tooltip } from 'antd';
import { POPUP_SHOW_DELAY, POPUP_HIDE_DELAY } from '../../domain/ui';

export const Hint = (props) => {
    const {
        children,
        mouseEnterDelay = POPUP_SHOW_DELAY,
        mouseLeaveDelay = POPUP_HIDE_DELAY,
        placement = 'bottomRight',
        ...rest
    } = props;

    return (
        <Tooltip mouseEnterDelay={mouseEnterDelay} mouseLeaveDelay={mouseLeaveDelay} placement={placement} {...rest}>
            {children}
        </Tooltip>
    );
};

Hint.propTypes = {
    mouseEnterDelay: PropTypes.number,
    mouseLeaveDelay: PropTypes.number,
    placement: PropTypes.oneOf([
        'top',
        'left',
        'right',
        'bottom',
        'topLeft',
        'topRight',
        'bottomLeft',
        'bottomRight',
        'leftTop',
        'leftBottom',
        'rightTop',
        'rightBottom',
    ]),
};
