import React, { Fragment, useRef, useMemo } from 'react';
import PropTypes from 'prop-types';
import ImageViewer from 'react-wp-viewer';
import { DOCUMENT_TYPES } from '../../domain/documents';
import { translate } from '../../utils/translate';
import './ViewerPane.less';

export const ViewerPaneView = ({ activeDocumentIndex, images, onChange }) => {
    const containerRef = useRef(null);
    const imageUrls = useMemo(
        () => Object.values(images).map(({ src, documentType }) => ({ src, alt: translate(documentType) })),
        [images],
    );

    return (
        <Fragment>
            <div className="image-viewer-container" ref={containerRef} />
            <ImageViewer
                container={containerRef}
                visible={true}
                changeable={false}
                loop={true}
                noClose={true}
                noResetAfterChange={true}
                noImgDetails={true}
                noNavbar={imageUrls && imageUrls.length === 1}
                showTotal={false}
                zoomSpeed={0.35}
                onChange={onChange}
                images={imageUrls}
                activeIndex={activeDocumentIndex}
            />
        </Fragment>
    );
};

ViewerPaneView.propTypes = {
    activeDocumentIndex: PropTypes.number.isRequired,
    images: PropTypes.shape({
        [PropTypes.oneOf(Object.values(DOCUMENT_TYPES))]: PropTypes.shape({
            src: PropTypes.string,
            documentType: PropTypes.oneOf(Object.values(DOCUMENT_TYPES)).isRequired,
        }),
    }),
    onChange: PropTypes.func.isRequired,
};
