import { connect } from 'react-redux';
import { setActiveDocumentIndex } from '../../domain/store/actions/ui';
import { ViewerPaneView } from './ViewerPane';

const mapStateToProps = (state) => {
    const { images } = state.documents;
    const { activeDocumentIndex } = state.ui;

    return {
        images,
        activeDocumentIndex,
    };
};

const mapDispatchToProps = (dispatch) => ({
    onChange: (_, index) => dispatch(setActiveDocumentIndex(index)),
});

export const ViewerPane = connect(mapStateToProps, mapDispatchToProps)(ViewerPaneView);
