export const DOCUMENT_TYPES = {
    passportBio: 'passport_biographical',
    passportReg: 'passport_registration',
    passportSelfie: 'passport_selfie',
    licenseFront: 'license_front',
    licenseBack: 'license_back',
    licenseSelfie: 'license_selfie',
    selfie: 'selfie',
};

export const DEFAULT_FIELDS_ORDER = {
    [DOCUMENT_TYPES.passportBio]: [
        'last_name',
        'first_name',
        'middle_name',
        'gender',
        'citizenship',
        'birth_place',
        'birth_date',
        'number',
        'issue_date',
        'issued_by',
        'subdivision_code',
        'expiration_date',
    ],
    [DOCUMENT_TYPES.passportReg]: [
        'region',
        'area',
        'locality',
        'street',
        'house',
        'housing',
        'registration_letter',
        'apartment',
        'registration_expiration_date',
    ],
    [DOCUMENT_TYPES.licenseFront]: [
        'last_name',
        'first_name',
        'middle_name',
        'birth_date',
        'categories',
        'number',
        'issue_date',
        'prev_licence_number',
        'categories_b_valid_to_date',
        'issued_by',
        'special_category_b_date',
        'prev_licence_issue_date',
        'experience_from',
    ],
    [DOCUMENT_TYPES.licenseBack]: [
        'number',
        'categories',
        'categories_b_valid_from_date',
        'categories_b_valid_to_date',
        'special_category_b_date',
        'prev_licence_issue_date',
        'prev_licence_number',
        'experience_from',
        'has_at_mark',
    ],
    [DOCUMENT_TYPES.selfie]: [],
};

export const GENDERS = {
    male: 'MALE',
    female: 'FEMALE',
};

export const LICENSE_CATEGORIES = {
    b: 'B',
    other: '-',
};

export const VERDICT_OK = 'OK';
export const VERDICT_OTHER = 'OTHER';
export const VERDICT_NOT_DOCUMENT = 'NOT_DOCUMENT';
export const VERDICT_NOT_OBJECT = 'NO_OBJECT';
export const VERDICT_FOREIGN_DOCUMENT = 'FOREIGN';
export const VERDICT_WRONG_DOC = 'WRONG_DOC';
export const HIDE_AUTOFILL_VERDICTS = [
    VERDICT_NOT_DOCUMENT,
    VERDICT_FOREIGN_DOCUMENT,
    VERDICT_NOT_OBJECT,
    VERDICT_WRONG_DOC,
];

export const MIN_ALLOWED_BIRTH_YEAR = 1930;
