import { createStore, compose } from 'redux';
import taskReducer from './reducers';
import { loadInputValues } from './actions/input';
import { resetMiddleware } from './middleware';
import { DOCUMENT_TYPES } from '../documents';
import { setScaleOptions } from './actions/ui';

export const store = compose(resetMiddleware())(createStore)(taskReducer);
export const dispatch = store.dispatch;

export const initStore = (input, facts = {}, confidenceThresholds = {}, scaleOptions) => {
    const {
        secret,
        document_types: documentTypes = DOCUMENT_TYPES,
        meta,
        is_foreign: isForeign,
        is_custom_field: isCustomField,
        outdata,
        task_type: taskType,
        user_id: userId
    } = input;

    dispatch(
        loadInputValues({
            secret,
            documentTypes,
            availableFields: meta.available_fields,
            facts,
            confidenceThresholds,
            isForeign,
            isCustomField,
            outdata,
            taskType,
            userId
        }),
    );
    dispatch(setScaleOptions(scaleOptions));
};

export const resetStore = () => dispatch({ type: 'RESET' });
