export class TemplateBackendActionsCollector {
    backendActions = [];

    setAction(action, state) {
        const converter = this.resolveConverter(action.type);

        if (!converter) {
            return;
        }

        // eslint-disable-next-line no-unused-vars
        const { meta, ...actionWithoutMeta } = action;

        this.backendActions = converter(this.backendActions, actionWithoutMeta, state);
    }

    getBackendActions() {
        return this.backendActions.map((action) => {
            // eslint-disable-next-line no-unused-vars
            const { meta, ...rest } = action;

            return rest;
        });
    }

    resetActions() {
        this.backendActions = [];
    }

    resolveConverter() {
        return null;
    }
}

let collector;

export const getBackendActionsCollector = () => {
    if (!collector) {
        collector = new TemplateBackendActionsCollector();
    }

    return collector;
};
