export const resetMiddleware = (options) => (next) => (reducer, initialState, enhancer) => {
    let resetType = 'RESET';

    let resetData = 'state';

    if ((typeof options === 'string' && options.length > 0) || typeof options === 'symbol') {
        resetType = options;
    } else if (typeof options === 'object') {
        resetType =
            (typeof options.type === 'string' && options.type.length > 0) || typeof options === 'symbol'
                ? options.type
                : resetType;
        resetData = typeof options.data === 'string' && options.data.length > 0 ? options.data : resetData;
    }

    const enhanceReducer = (state, action) => {
        if (action.type === resetType) {
            // eslint-disable-next-line no-param-reassign
            state = action[resetData];
        }
        return reducer(state, action);
    };

    return next(enhanceReducer, initialState, enhancer);
};
