import { getType } from 'typesafe-actions';
import * as actions from '../actions/documents';

const initialState = {
    images: {},
    documents: {},
    formsData: {},
};

const documentsReducer = (state = initialState, action) => {
    switch (action.type) {
        case getType(actions.setImage):
            const { documentType } = action.payload;

            return {
                ...state,
                images: {
                    ...state.images,
                    [documentType]: { ...action.payload },
                },
            };

        case getType(actions.setInitialDocumentsData):
            return {
                ...state,
                documents: {
                    ...state.documents,
                    ...action.payload,
                },
            };

        case getType(actions.setInitialFormsData):
            return {
                ...state,
                formsData: {
                    ...state.formsData,
                    ...action.payload,
                },
            };

        default:
            return state;
    }
};

export default documentsReducer;
