/* eslint-disable camelcase */
import { getType } from 'typesafe-actions';
import * as actions from '../actions/solution';

export const documentsFactory = (documentTypes, initialValues) =>
    Object.values(documentTypes).reduce((documents, document) => ({ ...documents, [document]: initialValues }), {});

const initialState = {
    documents: {},
    verdicts: {},
    comments: {},
};

const solutionReducer = (state = initialState, action) => {
    switch (action.type) {
        case getType(actions.initSolution):
            return {
                ...state,
                documents: {
                    ...state.documents,
                    ...action.payload.documents,
                },
                verdicts: documentsFactory(action.payload.documentTypes, []),
                comments: documentsFactory(action.payload.documentTypes, ''),
            };

        case getType(actions.setVerdictAndComment):
            return {
                ...state,
                verdicts: {
                    ...state.verdicts,
                    ...(action.payload.verdicts || {}),
                },
                comments: {
                    ...state.comments,
                    ...(action.payload.comments || {}),
                },
            };

        case getType(actions.setDocumentData):
            const actionEntries = Object.entries(action.payload.values ?? {});
            const newValues = {};
            const dateFields = [
                'birth_date', 'issue_date', 'expiration_date', 'registration_expiration_date',
                'categories_b_valid_to_date', 'special_category_b_date', 'experience_from',
                'prev_licence_issue_date', 'categories_b_valid_from_date',
            ];

            actionEntries.forEach((el) => {
                if (el) {
                    newValues[el[0]] = el[1]
                        ? el[1]
                        : dateFields.includes(el[0]) ? null : '';
                }
            });

            return {
                ...state,
                documents: {
                    ...state.documents,
                    [action.payload.documentType]: {
                        ...state.documents[action.payload.documentType],
                        data: {
                            ...state.documents[action.payload.documentType]?.data,
                            ...newValues,
                        },
                    },
                },
            };

        default:
            return state;
    }
};

export default solutionReducer;
