import { getType } from 'typesafe-actions';
import * as actions from '../actions/ui';

const initialState = {
    activeDocumentIndex: 0,
    submitRequests: {},
    taskError: null,
    scaleOptions: {
        multipleSelect: false,
        otherWithComment: false,
        sendToBackend: false,
        sendToOutputValues: false,
    },
    submitting: false,
};

const uiReducer = (state = initialState, action) => {
    switch (action.type) {
        case getType(actions.setScaleOptions):
            return {
                ...state,
                scaleOptions: { ...action.payload },
            };

        case getType(actions.setActiveDocumentIndex):
            return {
                ...state,
                activeDocumentIndex: action.payload,
            };

        case getType(actions.setTaskError):
            return {
                ...state,
                taskError: action.payload,
            };

        case getType(actions.setSubmitInProgress):
            return {
                ...state,
                submitting: action.payload,
            };

        case getType(actions.setError):
            return {
                ...state,
                error: action.payload,
            };

        case getType(actions.setAssignmentId):
            return {
                ...state,
                assignmentId: action.payload,
            };

        case getType(actions.setSandboxChannels):
            return {
                ...state,
                sandboxChannels: action.payload,
            };

        default:
            return state;
    }
};

export default uiReducer;
