import CommonError from './CommonError';
import { translate } from '../../utils/translate';

export const STATUS_404 = 404;
export const STATUS_403 = 403;
export const STATUS_401 = 401;
export const STATUS_500 = 500;

const getErrorMessage = ({ status, json, message }) => {
    if (json.message) {
        return json.message;
    }

    if (Array.isArray(json.error?.message) && json.error.message.length) {
        return json.error.message[0];
    }

    if (status === STATUS_404 && !message) {
        return translate('error_not_found');
    }

    if (status === STATUS_403 && !message) {
        return translate('error_permission');
    }

    return message || translate('error_common');
};

export class ServerError extends CommonError {
    constructor({ status, message = '', json = {}, ...rest }) {
        const defaultMessage = getErrorMessage({ status, json, message });

        super({ status, message: defaultMessage, json, ...rest }, defaultMessage);

        this.message = defaultMessage;
        this.status = status;
        this.json = json;
    }
}

export function createProxyServerError(response) {
    const { status, responseText: message, responseJSON: json } = response;

    return new ServerError({
        status,
        message,
        json,
    });
}
