let serviceLocator = null;

class ServiceLocator {
    set validateAndCollect(callback) {
        this._validateAndCollect = callback;
    }

    get validateAndCollect() {
        return this._validateAndCollect;
    }

    get ChecksREST() {
        return this._checksREST;
    }

    get DataREST() {
        return this._dataREST;
    }

    get MediaREST() {
        return this._mediaREST;
    }

    get GeoREST() {
        return this._geoREST;
    }

    constructor({ ChecksREST, MediaREST, DataREST, GeoREST }) {
        this._checksREST = ChecksREST;
        this._dataREST = DataREST;
        this._mediaREST = MediaREST;
        this._geoREST = GeoREST;
    }
}

function serviceLocatorFactory(settings, { replace = false } = {}) {
    if (serviceLocator !== null && replace !== true) {
        throw new Error('Service locator has already been created.');
    }
    serviceLocator = new ServiceLocator(settings);
    return serviceLocator;
}

export { serviceLocatorFactory, serviceLocator };
