/* eslint-disable camelcase */
import { TaskPageController } from './TaskPageController';

export default class DriveTask extends window.TolokaTask {
    render() {
        this.initController();
        document.head.appendChild(this.getStyleDOMElement());

        this.onRender();
        this.hotkey.destroy();

        return this;
    }

    initController() {
        const taskSuite = this.getAssignment().getTaskSuite();

        this.controller = new TaskPageController({
            element: this.getDOMElement(),
            input: this.getTask().input_values,
            facts: taskSuite.getFacts(),
            confidenceThresholds: taskSuite.getConfidenceThresholds(),
            scaleOptions: taskSuite.getScaleOptions(),
        });

        if (this.controller) {
            this.controller.run();
        }
    }

    onDestroy() {
        if (this.controller) {
            this.controller.destroy();
        }
    }

    getSolution() {
        return {
            task_id: this.getTask().id,
            output_values: {
                ...this.controller.getResults(),
            },
        };
    }

    async validate(solutions) {
        try {
            await this.controller.validateAndCollect();
        } catch {
            return { task_id: this.getOptions().task.id, errors: {} };
        }

        return super.validate(solutions);
    }

    /**
     * @param {SolutionValidationError} errors
     */
    onValidationFail(errors) {
        super.onValidationFail(errors);

        Object.entries(errors.errors).forEach(([fieldName, fieldValue]) => {
            if (fieldName === '__TASK__') {
                this.controller.showTaskError(fieldValue?.message);
            }
        });
    }
}
