import { store } from '../domain/store';

export const convertOutputUsecase = (formsData) => {
    const { documents } = store.getState().documents;

    return Object.entries(documents).reduce((results, [document, { data }]) => {
        if (!formsData[document]) {
            return results;
        }

        return {
            ...results,
            [document]: {
                data: {
                    ...data,
                    ...(formsData[document]?.data || {}),
                },
            },
        };
    }, {});
};
