import { serviceLocator } from '../infrastructure/serviceLocator';
import { dispatch } from '../domain/store';
import { setImage } from '../domain/store/actions/documents';
import {initErrorCounter, logError} from "../error-logger/errorLog";

export const getMediaLinksUsecase = ({secret, documentTypes, assignmentId}) => {
    documentTypes.forEach((documentType) => {
        let src = serviceLocator.DataREST
            .getProxyRequestUrl('assignment/document_data', { photo_type: documentType, secretId: secret });

        let img = new Image();
        img.onerror = () => {
            initErrorCounter(secret);
            logError(
                {message: 'Не удалось загрузить медиа'},
                `src: ${src}; secret: ${secret}, assignmentId: ${assignmentId}`
                )
            dispatch(setImage({documentType, src, isValid: false}))
        }

        dispatch(setImage({documentType, src}));

        img.src = src;
    })
}
