import { serviceLocator } from '../infrastructure/serviceLocator';
import { withErrorAlert } from './utils';
import { dispatch, store } from '../domain/store';
import {setError, setSubmitInProgress} from '../domain/store/actions/ui';
import { stringify } from 'qs';

export const submitResultsUsecase = async (data) => {
    const { secret } = store.getState().input;
    const queryParams = stringify({ secretId: secret, patch: true }, { addQueryPrefix: true });

    dispatch(setSubmitInProgress(true));

    await withErrorAlert(
        async () => {
            await serviceLocator.DataREST.request({
                url: `assignment/user_info${queryParams}`,
                method: 'POST',
                body: data ?? {},
            });
            dispatch(setSubmitInProgress(false));
        },
        {
            onError: (e) => {
                dispatch(setError(e));
                dispatch(setSubmitInProgress(false));

                throw e;
            },
        },
    );
};
