import { message } from 'antd';
import { translate } from '../utils/translate';

export const withErrorAlert = async (fn, options = {}) => {
    try {
        await fn();
    } catch (e) {
        message.error(options.message || e ? e.message : translate('error_fetch'));

        if (options.onError) {
            options.onError(e);
        }

        return e;
    }
};
