import { isEmptyObject } from './fn';

export function setOnlyAvailableFields(documents, availableFields) {
    const newDocuments = {};

    // save only available fields for building form
    Object.entries(documents)?.forEach((el) => {
        if (isEmptyObject(el[1]) && availableFields[el[0]]?.length) {
            newDocuments[el[0]] = { data: {} };

            availableFields[el[0]].forEach((item) => {
                newDocuments[el[0]].data = {
                    ...newDocuments[el[0]].data ?? {},
                    [item]: null,
                };
            });
        } else {
            newDocuments[el[0]] = el[1];
        }
    });

    return newDocuments;
}
