exports.Assignment = extend(
    Drive.Assignment,
    function (options) {
        Drive.Assignment.call(this, options);
    },
    {},
);

exports.Task = extend(
    Drive.Task,
    function (options) {
        Drive.Task.call(this, options);
    },
    {},
);

exports.TaskSuite = extend(
    Drive.TaskSuite,
    function (options) {
        Drive.TaskSuite.call(this, options);
    },
    {
        getUserLocale: function () {
            return {
                en: {},
                ru: {},
            };
        },

        getProxyNames: function () {
            return {
                checks: 'robot-yang-cars-registration-documents_checks/set_status',
                data: 'robot-yang-cars-registration-data',
                media: 'robot-yang-cars-registration',
                geo: 'robot-yang-cars-search-geo',
            };
        },

        getFacts: function () {
            return {
                passport_biographical: {
                    NOT_DOCUMENT: 'Нет документа',
                    FOREIGN: 'Иностранный документ',
                    WRONG_DOC: 'Не тот документ',
                    FAKE: 'Подделка',
                    NOT_ORIGIN: 'Не оригинал',
                    BAD_DOC: 'Перефото не поможет',
                    BAD_PHOTO: 'Перефото поможет',
                },
                passport_registration: {
                    VIDEO_ERROR: 'Ошибка видео',
                    STRANGER_HANDS: 'Помощь в съемке: Чужие руки',
                    NO_OBJECT: 'Нет документа',
                    NOT_ORIGINAL: 'Не оригинал документа',
                    CONSTRUCTION_SITE: 'Стройка на фоне',
                    HOSTEL_SITE: 'Общежитие на фоне',
                },
                passport_selfie: {
                    VIDEO_ERROR: 'Ошибка видео',
                    STRANGER_HANDS: 'Помощь в съемке: Чужие руки',
                    NO_OBJECT: 'Нет документа и/или человека',
                    NOT_ORIGINAL: 'Не оригинал документа',
                    CONSTRUCTION_SITE: 'Стройка на фоне',
                    HOSTEL_SITE: 'Общежитие на фоне',
                    UNCONSCIOUS_SELFIE: 'Человек не осознаёт, что делает',
                    SCREENCAP_SELFIE: 'Экранка селфи',
                    ASSISTED_SELFIE: 'Помощь в съемке: Делает селфи не сам',
                },
                license_front: {
                    VIDEO_ERROR: 'Ошибка видео',
                    STRANGER_HANDS: 'Помощь в съемке: Чужие руки',
                    NO_OBJECT: 'Нет документа',
                    NOT_ORIGINAL: 'Не оригинал документа',
                    CONSTRUCTION_SITE: 'Стройка на фоне',
                    HOSTEL_SITE: 'Общежитие на фоне',
                },
                license_back: {
                    VIDEO_ERROR: 'Ошибка видео',
                    STRANGER_HANDS: 'Помощь в съемке: Чужие руки',
                    NO_OBJECT: 'Нет документа',
                    NOT_ORIGINAL: 'Не оригинал документа',
                    CONSTRUCTION_SITE: 'Стройка на фоне',
                    HOSTEL_SITE: 'Общежитие на фоне',
                },
            };
        },

        getConfidenceThresholds: function () {
            return {
                license_front: {
                    categories: 1,
                    number: 0.85,
                    last_name: 0.85,
                    middle_name: 0.85,
                    first_name: 0.85,
                    country: 1,
                    issue_date: 0.872,
                    birth_date: 0.85,
                    experience_from: 1,
                },
                license_back: {
                    has_at_mark: 1,
                    number: 0.85,
                    prev_licence_number: 1,
                    country: 1,
                    categories_b_valid_from_date: 1,
                    experience_from: 1,
                    categories_b_valid_to_date: 1,
                    prev_licence_issue_date: 1,
                },
                passport_biographical: {
                    number: 0.85,
                    subdivision_code: 1,
                    last_name: 0.85,
                    middle_name: 0.85,
                    gender: 0.85,
                    first_name: 0.85,
                    country: '1',
                    issue_date: 0.85,
                    birth_date: 0.85,
                    birth_place: 1,
                    citizenship: 0.85,
                    expiration_date: 1,
                },
            };
        },

        getScaleOptions: function () {
            return {
                multipleSelect: false,
                otherWithComment: true,
                sendToBackend: false,
                sendToOutputValues: true,
            };
        },

        getSetStatusType: function () {
            return {
                license_front: "license_front_fill",
                license_back: "license_back_fill",
                passport_biographical: "passport_biographical_fill",
                passport_registration: "passport_registration_fill",
            };
        },
    },
);

function extend(ParentClass, constructorFunction, prototypeHash) {
    constructorFunction = constructorFunction || function () {};
    prototypeHash = prototypeHash || {};
    if (ParentClass) {
        constructorFunction.prototype = Object.create(ParentClass.prototype);
    }
    for (var i in prototypeHash) {
        constructorFunction.prototype[i] = prototypeHash[i];
    }
    return constructorFunction;
}
