#!/usr/bin/env bash

echo "Calculate version ..."
commitsCount=`arc log --oneline | wc -l | tr -d ' '`
branchName=`arc rev-parse --abbrev-ref HEAD | sed -e "s/\//-/"`

if [ $? -ne 0 ]; then
  exit 1;
fi

if test "$branchName" = "develop"; then
  VERSION="1.${commitsCount}_${SANDBOX_TASK_ID}"
else
  VERSION="1.${commitsCount}_${branchName}_${SANDBOX_TASK_ID}"
fi

echo "VERSION = $VERSION"
export VERSION=$VERSION
export BRANCH_NAME=$branchName
