const path = require('path');
const fs = require('fs');

const getRandom = (min, max) => Math.floor(Math.random() * (max - min + 1) + min);

const pictureDimensionsFactory = () => {
    const knownDocuments = [
        'passport_biographical',
        'passport_registration',
        'passport_selfie',
        'license_front',
        'license_back',
    ];

    return knownDocuments.reduce(
        (results, documentType) => ({
            ...results,
            ...{[documentType]: {width: getRandom(500, 1000), height: getRandom(500, 1000)}},
        }),
        {},
    );
};

const pictureDimensions = pictureDimensionsFactory();

module.exports = {
    certPath: path.resolve(__dirname, './ssl/dev.pem'),
    project: {
        title: 'Drive: registration',
        description: 'Toloka template for Drive users registration',
        instructions: 'TBD',
        hideSkip: true,
        markup: path.resolve(process.cwd(), './static/markup.hbs'),
        styles: path.resolve(process.cwd(), './static/styles.css'),
        script: path.resolve(process.cwd(), './static/script.js'),
        scriptUrls: ['https://local.yang.yandex-team.ru:3002/template-drive-documents.js'],
        tasks: [
            {
                id: 0,
                input_values: {
                    meta: {
                        available_fields: {
                            // license_front: ['birth_date', 'last_name', 'first_name'],
                            license_back: ['number', 'has_at_mark'],
                        },
                    },
                    secret: '12345',
                    user_id: 'b9eb0604-7594-4a11-98c0-0279b6432cc8',
                    document_types: [
                        'passport_biographical',
                        // 'passport_registration',
                        // 'passport_selfie',
                        'license_front',
                        // 'license_back',
                    ],
                    is_foreign: true,
                    is_custom_field: false,
                    // task_type: 'registration_on_chat',
                    outdata: {
                        passport_biographical: {
                            data: {
                                birth_date: "1999-01-01",
                                birth_place: "ГОР. МИНСК",
                                citizenship: "БЕЛАРУСЬ",
                                country: "rus",
                                first_name: "АНДРЕЙКА",
                                gender: "МУЖ",
                                issue_date: "2009-01-01",
                                last_name: "ПЕТРОВ",
                                middle_name: "ПЕТРОВИЧ",
                                number: "1104000000",
                                subdivision_code: "292-000"
                            }
                        }
                    }
                }
            },
        ],
        outputSpec: {
            verdicts: {
                type: 'json',
                required: true,
                hidden: false,
            },
            other: {
                type: 'json',
                required: false,
                hidden: false,
            },
            documents: {
                type: 'json',
                required: false,
                hidden: false,
            },
        },
        middleware: {
            before: [
                {
                    path: new RegExp('^/api/proxy/robot-yang-cars-registration-data/assignment/document_data?(.+)'),
                    handler: (req, res, next) => {
                        const documentType = req.query?.photo_type;

                        if (!pictureDimensions[documentType]) {
                            return next();
                        }

                        const {width, height} = pictureDimensions[documentType];

                        return res.redirect(`https://placekitten.com/${width}/${height}`);
                    },
                },
                {
                    path: new RegExp('^/api/proxy/robot-yang-cars-registration-data/assignment/user_info?(.+)'),
                    method: 'post',
                    handler: (req, res, next) => {
                        res.writeHead(200, {
                            foo: 'bar',
                        });
                        return res.end();
                    },
                },
                {
                    path: new RegExp('^/api/proxy/robot-yang-cars-registration-data/assignment/user_info?(.+)'),
                    method: 'get',
                    handler: (req, res, next) => {
                        const filePath = path.resolve(__dirname, './mocks/document_rus.json');

                        return fs.existsSync(filePath) ? res.json(require(filePath)) : next();
                    },
                },
                {
                    path: new RegExp('^/api/proxy/robot-yang-cars-registration-documents-cheks/set_status'),
                    method: 'post',
                    handler: (req, res, next) => {
                        res.writeHead(200, {
                            foo: 'bar',
                        });
                        return res.end();
                    },
                },
                {
                    path: new RegExp('^/api/proxy/robot-yang-cars-search-geo/'),
                    handler: (req, res, next) => {
                        const filePath = path.resolve(__dirname, `./mocks/address.json`);

                        return fs.existsSync(filePath) ? res.json(require(filePath)) : next();
                    },
                },
                {
                    path: new RegExp('^/api/proxy/robot-yang-cars-registration-data/assignment/queue?(.+)'),
                    method: 'post',
                    handler: (req, res, next) => {
                        res.writeHead(200, {
                            foo: 'bar',
                        });
                        return res.end();
                    },
                },
            ],
        },
    },
};
