import defaultTranslations from './i18n.json';

const supportedLanguages = ['ru', 'en'];

export const createTranslationKeys = (additionalTranslations) =>
    supportedLanguages.reduce((result, lng) => {
        result[lng] = {
            translation: {
                ...defaultTranslations[lng],
                ...additionalTranslations[lng],
            },
        };
        return result;
    }, {});
