import React from 'react';
import PropTypes from 'prop-types';
import { Checkbox as AntCheckbox } from 'antd';

export class Checkbox extends React.PureComponent {
    static propTypes = {
        hotKey: PropTypes.shape({
            code: PropTypes.string.isRequired,
            label: PropTypes.oneOfType([PropTypes.string, PropTypes.number]).isRequired,
        }),
        checked: PropTypes.bool,
        disabled: PropTypes.bool,
        onChange: PropTypes.func,
    };

    handleHotKey = (e) => {
        if (
            this.props.disabled
            || e.code !== this.props.hotKey?.code
            || (document.activeElement
                && document.activeElement.tagName === 'INPUT'
                && document.activeElement.type === 'text')
        ) {
            return;
        }

        this.props.onChange({
            target: {
                checked: !this.props.checked,
            },
        });

        e.preventDefault();
    };

    componentDidMount() {
        if (this.props.hotKey) {
            document.addEventListener('keydown', this.handleHotKey);
        }
    }

    componentWillUnmount() {
        if (this.props.hotKey) {
            document.removeEventListener('keydown', this.handleHotKey);
        }
    }

    render() {
        const { hotKey, children, ...rest } = this.props;

        return (
            <AntCheckbox {...rest}>
                {children}
                {hotKey && <sup>{hotKey.label}</sup>}
            </AntCheckbox>
        );
    }
}
