import { addVerdict, setVerdict, removeVerdict, setComment } from '../../domain/store/actions/solution';
import { setFormError, setTaskError } from '../../domain/store/actions/common';
import { connect } from 'react-redux';
import { SidebarView } from './Sidebar';
import { getAgeUsecase } from '../../usecases/getAgeUsecase';

const mapStateToProps = (state) => {
    const { common, solution, input } = state;
    const { taskError, signals, facts } = common;
    const { secret, task_type: taskType, document_types: documentTypes } = input;

    return {
        verdicts: solution.verdicts,
        comment: solution.comment,
        facts: taskType === 'registration_on_chat' ? Object.values(facts)[0] : facts,
        taskError,
        validateSignal: signals.validation,
        secret,
        taskType,
        documentTypes,
    };
};

const mapDispatchToProps = (dispatch) => ({
    addVerdict: (verdict) => dispatch(addVerdict(verdict)),
    setVerdict: (verdict) => dispatch(setVerdict(verdict)),
    removeVerdict: (name) => dispatch(removeVerdict(name)),
    setComment: (value) => dispatch(setComment(value)),
    setFormError: (errorFlag) => dispatch(setFormError(errorFlag)),
    resetTaskError: () => dispatch(setTaskError(null)),
    preloadAgeData: getAgeUsecase,
});

export const Sidebar = connect(mapStateToProps, mapDispatchToProps)(SidebarView);
