/* eslint-disable camelcase */
import React, { PureComponent, Fragment } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import Storage from '../../utils/storage';
import { translate } from '../../utils/translate';
import { DOCUMENT_TYPES } from '../../domain/constants';
import ImageViewer from 'react-wp-viewer';
import SplitPane from 'react-split-pane';
import { Sidebar } from '../Sidebar';
import './TaskPageLayout.less';

// eslint-disable-next-line no-magic-numbers
const EXPIRATION_TIME = 365 * 24 * 60 * 60 * 1000;
const DEFAULT_PANE_SIZE = 460;

export class TaskPageLayoutView extends PureComponent {
    static propTypes = {
        imageUrls: PropTypes.arrayOf(
            PropTypes.shape({
                type: PropTypes.oneOf(DOCUMENT_TYPES),
                src: PropTypes.string.isRequired,
            }),
        ).isRequired,
        availableDocumentTypes: PropTypes.arrayOf(PropTypes.oneOf(DOCUMENT_TYPES)),
    };

    get splitSize() {
        return this.storage.getItem('splitSizeDSB') || DEFAULT_PANE_SIZE;
    }

    constructor(props) {
        super(props);

        this.storage = new Storage();
        this.props.availableDocumentTypes.forEach((type) => (this[type] = React.createRef()));
    }

    componentWillUnmount() {
        this.storage.destroy();
    }

    handleSplitSize = (size) => this.storage.setItem('splitSizeDSB', size, new Date().getTime() + EXPIRATION_TIME);

    renderViewer = ({ type, src }) => (
        <Fragment key={type}>
            <div className={classNames('image-viewer-container', type)} ref={this[type]} />
            <ImageViewer
                container={this[type]}
                visible={true}
                changeable={false}
                noClose={true}
                noNavbar={true}
                noResetAfterChange={true}
                noImgDetails={true}
                showTotal={false}
                disableKeyboardSupport={true}
                zoomSpeed={0.15}
                images={[{ src, alt: translate(type) }]}
            />
        </Fragment>
    );

    render() {
        const { imageUrls } = this.props;

        return (
            <div className="task-pane">
                <div className="task-pane__row">
                    <SplitPane
                        primary="second"
                        split="vertical"
                        minSize={DEFAULT_PANE_SIZE}
                        defaultSize={this.splitSize}
                        onDragFinished={this.handleSplitSize}
                    >
                        <main className="task-pane__main">{imageUrls.map(this.renderViewer)}</main>

                        <aside className="task-pane__aside">
                            <Sidebar />
                        </aside>
                    </SplitPane>
                </div>
            </div>
        );
    }
}
