import { connect } from 'react-redux';
import { TaskPageLayoutView } from './TaskPageLayout';
import { getImageLinksUsecase } from '../../usecases/getImageLinksUsecase';

const mapStateToProps = (state) => {
    const { secret, document_types: availableDocumentTypes } = state.input;

    return {
        availableDocumentTypes,
        imageUrls: getImageLinksUsecase({ secret, availableDocumentTypes }),
    };
};

export const TaskPageLayout = connect(mapStateToProps, null)(TaskPageLayoutView);
