import React, { Component } from 'react';
import PropTypes from 'prop-types';

export const withHotkey = (InputComponent) =>
    // eslint-disable-next-line react/display-name
    class extends Component {
        static propTypes = {
            hotKey: PropTypes.shape({
                code: PropTypes.string.isRequired,
                label: PropTypes.oneOfType([PropTypes.string, PropTypes.number]).isRequired,
            }),
            multiple: PropTypes.bool,
            disabled: PropTypes.bool,
            onChange: PropTypes.func,
            checked: PropTypes.oneOfType([PropTypes.bool, PropTypes.arrayOf(PropTypes.string)]),
        };

        handleHotKey = (e) => {
            const { disabled, hotKey, onChange, multiple, checked, id } = this.props;

            if (
                disabled
                || e.code !== hotKey?.code
                || (document.activeElement
                    && document.activeElement.tagName === 'INPUT'
                    && document.activeElement.type === 'text')
            ) {
                return;
            }

            onChange(
                multiple
                    ? {
                        target: {
                            checked: !!!checked,
                            id,
                        },
                    }
                    : {
                        target: {
                            checked: true,
                            id,
                        },
                    },
            );

            e.preventDefault();
        };

        componentDidMount() {
            if (this.props.hotKey) {
                document.addEventListener('keydown', this.handleHotKey);
            }
        }

        componentWillUnmount() {
            if (this.props.hotKey) {
                document.removeEventListener('keydown', this.handleHotKey);
            }
        }

        render() {
            const { hotKey, children, ...rest } = this.props;

            return (
                <InputComponent {...rest}>
                    {children}
                    {hotKey && <sup>{hotKey.label}</sup>}
                </InputComponent>
            );
        }
    };
