import { createStore, compose } from 'redux';
import taskReducer from './reducers';
import { loadInputValues } from './actions/input';
import { setFacts } from './actions/common';
import { resetMiddleware } from './middleware';
import { DOCUMENT_TYPES } from '../constants';

export const store = compose(resetMiddleware())(createStore)(taskReducer);
export const dispatch = store.dispatch;

export const initStore = (input, facts) => {
    /* eslint-disable camelcase */
    const availableDocumentTypes = Array.isArray(input.document_types)
        ? input.document_types.filter((document) => DOCUMENT_TYPES.includes(document))
        : DOCUMENT_TYPES;

    dispatch(loadInputValues({ ...input, document_types: availableDocumentTypes }));
    dispatch(setFacts(facts));
};

export const resetStore = () => dispatch({ type: 'RESET' });
