import { getType } from 'typesafe-actions';
import * as actions from '../actions/common';

const initialState = {
    formError: false,
    facts: {},
    signals: {
        validation: null,
    },
    taskError: null,
};

const commonReducer = (state = initialState, action) => {
    switch (action.type) {
        case getType(actions.setFormError):
            return {
                ...state,
                formError: action.payload,
            };

        case getType(actions.sendValidationSignal):
            return {
                ...state,
                signals: {
                    ...state.signals,
                    validation: Date.now(),
                },
            };

        case getType(actions.setTaskError):
            return {
                ...state,
                taskError: action.payload,
            };

        case getType(actions.setFacts):
            return {
                ...state,
                facts: action.payload,
            };

        default:
            return state;
    }
};

export default commonReducer;
