import { getType } from 'typesafe-actions';
import * as actions from '../actions/solution';
import { VERDICT_OK } from '../../constants';

const initialState = {
    verdicts: [],
    comment: '',
};

const solutionReducer = (state = initialState, action) => {
    switch (action.type) {
        case getType(actions.addVerdict):
            return {
                ...state,
                verdicts:
                    action.payload === VERDICT_OK
                        ? [VERDICT_OK]
                        : [...state.verdicts.filter((verdict) => verdict !== VERDICT_OK), action.payload].sort(),
                comment: action.payload === VERDICT_OK ? '' : state.comment,
            };

        case getType(actions.setVerdict):
            return {
                ...state,
                verdicts: [
                    ...(action.payload.verdicts || state.verdicts),
                ],
                comment: action.payload.comment || state.comment,
            };

        case getType(actions.setComment):
            return {
                ...state,
                comment: action.payload,
            };

        case getType(actions.removeVerdict):
            return {
                ...state,
                verdicts: [...state.verdicts].filter((verdict) => verdict !== action.payload).sort(),
            };

        default:
            return state;
    }
};

export default solutionReducer;
