import {store} from '../domain/store';
import {serviceLocator} from '../infrastructure/serviceLocator';
import {stringify} from "qs";
import { VERDICT_BAD_PHOTO } from '../domain/constants';

export default class DriveAssignment extends window.TolokaAssignment {
    /**
     * Provides solutions to the app if they are valid.
     *
     * @param {Function} strategy
     * @param {Function} errorCallback - called if validation errors
     */
    provideSolutions(
        strategy = function(solutions) {
            this.getSandboxChannel().triggerOut('assignment:submit', { solutions, assignmentId: this.getId() });
        },
        // eslint-disable-next-line no-unused-vars
        errorCallback = function() {},
    ) {
        const solutions = this.getTaskSuite().getSolutions();

        const {task_type: taskType} = store.getState()?.input;

        Promise.resolve(this.getTaskSuite().validate(solutions)).then(async (errors) => {
            if (!errors) {
                if (taskType === 'registration_on_chat') {
                    await this.addToQueueRequest(strategy, solutions);
                } else {
                    strategy.call(this, solutions);
                }
            } else {
                this.getSandboxChannel().triggerOut('assignment:validation:fail', errors);
            }
        });
    }

    async addToQueueRequest(strategy, solutions) {
        const { input, common } = store.getState();
        const { secret } = input;
        const generalType = Object.keys(common.facts)[0];
        const queryParams = stringify({ secretId: secret }, { addQueryPrefix: true });
        const statusTypes = this.getTaskSuite().getSetStatusType();
        const { other, general: verdicts } = solutions[0].output_values;
        const output_values = {};

        output_values.verdicts = typeof verdicts[0] === 'string'
            ? { [generalType]: [verdicts[0]] }
            : verdicts[0][VERDICT_BAD_PHOTO].reduce((prev, curr) => ({
                ...prev,
                [statusTypes[curr]]: [VERDICT_BAD_PHOTO],
            }), {});

        solutions[0].output_values = { ...output_values, other };

        await serviceLocator.DataREST.request({
            url: `assignment/queue${queryParams}`,
            method: 'POST',
        }).then(() => {
            solutions[0].output_values.send_server_status = 'ok';
            strategy.call(this, solutions);
        }).catch((error) => {
            const SUCCESS_STATUS = 200;

            if (error?.status && error?.status !== SUCCESS_STATUS) {
                solutions[0].output_values.send_server_status = 'error';
                strategy.call(this, solutions);
            } else {
                solutions[0].output_values.send_server_status = 'ok';
                strategy.call(this, solutions);
            }
        });
    }
}
