/* eslint-disable camelcase */
import { TaskPageController } from './TaskPageController';

// eslint-disable-next-line no-undef
export default class DriveSBSTask extends TolokaTask {
    render() {
        this.initController();
        document.head.appendChild(this.getStyleDOMElement());

        this.onRender();
        this.hotkey.destroy();

        return this;
    }

    initController() {
        const input = this.getTask().input_values;
        const taskSuite = this.getAssignment().getTaskSuite();
        this.controller = new TaskPageController({
            element: this.getDOMElement(),
            input,
            facts: input.task_type === 'registration_on_chat'
                ? taskSuite.getFactsOnRegistration()
                : taskSuite.getFacts()
        });

        if (this.controller) {
            this.controller.run();
        }
    }

    onDestroy() {
        if (this.controller) {
            this.controller.destroy();
        }
    }

    getSolution() {
        const { verdicts: general, comment: other } = this.controller.getResults();

        return {
            task_id: this.getTask().id,
            output_values: {
                general,
                other,
            },
        };
    }

    async validate(solution) {
        const errors = await this.controller.validate();

        if (errors) {
            return { task_id: this.getOptions().task.id, errors: {} };
        }

        return super.validate(solution);
    }

    /**
     * @param {SolutionValidationError} errors
     */
    onValidationFail(errors) {
        super.onValidationFail(errors);

        Object.keys(errors.errors).forEach((fieldName) => {
            if (fieldName === '__TASK__') {
                this.controller.showTaskError(errors.errors[fieldName]?.message || errors.errors[fieldName]);
            }
        });
    }
}
