import { createElement } from 'react';
import { render, unmountComponentAtNode } from 'react-dom';
import { sleep } from '../utils/fn';
import { initStore, resetStore, store } from '../domain/store';
import { sendValidationSignal, setTaskError } from '../domain/store/actions/common';
import { TaskView } from '../components/TaskView';

const VALIDATION_DELAY = 100;

export class TaskPageController {
    constructor({ element, input, facts }) {
        this.element = element;
        this.input = input;
        this.facts = facts;
    }

    get view() {
        return this._view;
    }

    createView() {
        this._view = render(createElement(TaskView), this.element);
    }

    getResults() {
        return store.getState().solution || {};
    }

    run() {
        initStore(this.input, this.facts);
        this.createView();
    }

    destroy() {
        unmountComponentAtNode(this.element);

        if (this.element.parentNode) {
            this.element.parentNode.removeChild(this.element);
        }

        resetStore();
    }

    showTaskError(message) {
        store.dispatch(setTaskError(message));
    }

    async validate() {
        store.dispatch(sendValidationSignal());
        await sleep(VALIDATION_DELAY);

        return store.getState().common.formError;
    }
}
