import { stringify } from 'qs';
import { serviceLocator } from '../infrastructure/serviceLocator';

export const getAgeUsecase = async ({ secret }) => {
    const queryParams = stringify({ secretId: secret }, { addQueryPrefix: true });

    let assignmentDocuments = await serviceLocator.DataREST.read(`assignment/user_info${queryParams}`);

    let { license_front, passport_biographical } = assignmentDocuments;

    const passportBirthday = Date.parse(passport_biographical?.data?.birth_date);
    const licenseBirthday = Date.parse(license_front?.data?.birth_date);
    const today = Date.now();

    const passportAge = new Date(today - passportBirthday).getUTCFullYear() - 1970;
    const licenseAge = new Date(today - licenseBirthday).getUTCFullYear() - 1970;

    return { passportAge, licenseAge };
}
