import { serviceLocator } from '../infrastructure/serviceLocator';
import { stringify } from 'qs';

export const getImageLinksUsecase = ({ secret, availableDocumentTypes }) =>
    availableDocumentTypes.map((type) => {
        const queryParams = stringify({ photo_type: type, secretId: secret }, { addQueryPrefix: true });

        return {
            type,
            src: serviceLocator.DataREST.createProxiedUrl(`assignment/document_data${queryParams}`),
        };
    });
