/**
 * f([xs, ys, ...]) -> [...xs, ...xy, ...]
 *
 * @param lists
 */
export function join(lists) {
    return lists.reduce((acc, x) => [...acc, ...x], []);
}

/**
 * f(a, b) -> a - b
 *
 * @param a
 * @param b
 * @returns {Set}
 */
export function difference(a, b) {
    return new Set([...a].filter((x) => !b.has(x)));
}

/**
 *
 *
 * @param ms time in milliseconds
 * @returns {Promise}
 */
export async function sleep(ms) {
    return new Promise((resolve) => {
        setTimeout(resolve, ms);
    });
}

/**
 * f(path) -> g(obj) -> obj[path]
 *
 * @param path
 * @returns {function(*=)}
 */
export function select(path) {
    // eslint-disable-next-line no-prototype-builtins
    return (obj) => path.split('.').reduce((acc, x) => (acc && acc.hasOwnProperty(x) ? acc[x] : null), obj);
}

/**
 * Remove trailing spaces from string
 *
 * f(_x_) => x
 *
 * @param str
 */
export function trim(str) {
    return str.replace(/^\s+/, '').replace(/\s+$/, '');
}

export function isSetsEqual(a, b) {
    if (a.size !== b.size) return false;

    let result = true;

    a.forEach((val) => {
        if (!b.has(val)) result = false;
    });

    return result;
}

export function upperCase(str) {
    return str.toUpperCase();
}

/**
 *
 * f(as, bs) -> [[ai, bi], ...]
 *
 * @param a
 * @param b
 * @returns {Array}
 */
export function zip(a, b) {
    const length = Math.min(a.length, b.length);
    const result = [];

    for (let i = 0; i < length; i++) result.push([a[i], b[i]]);

    return result;
}

/**
 *
 * f(a, b) => [a ... b)
 *
 * @param min
 * @param max
 * @returns {Array}
 */
export function range(min, max) {
    const result = [];

    for (let i = min; i < max; i++) result.push(i);
    return result;
}

/**
 *
 * f(a, b) => [a ... b]
 *
 * @param min
 * @param max
 * @returns {Array}
 */
export function rangeClosed(min, max) {
    const result = [];

    for (let i = min; i <= max; i++) result.push(i);
    return result;
}

/**
 *
 * @param obj
 * @returns {boolean|boolean}
 */
export const isObject = (obj) => {
    const type = typeof obj;

    return type === 'function' || (type === 'object' && !!obj);
};

/**
 *
 * Deep clone for plain JSON objects
 *
 * @param obj
 * @returns {any}
 */
export const deepClone = (obj) => {
    try {
        if (!isObject(obj)) return obj;
        const str = JSON.stringify(obj);

        return JSON.parse(str);
    } catch (e) {
        console.error(e);
    }
};

export const uuid = () =>
    /* eslint-disable no-magic-numbers */
    ([1e7] + -1e3 + -4e3 + -8e3 + -11e3).replace(/[018]/g, (c) =>
        (c ^ (crypto.getRandomValues(new Uint8Array(1))[0] & (15 >> (c / 4)))).toString(16),
    );
/* eslint-enable no-magic-numbers */

export const ellipsis = (str, maxSize) => {
    if (!maxSize) {
        return str;
    }

    return str.length > maxSize ? `${str.substr(0, maxSize)}...` : str;
};

/**
 * Sort object keys using the index order in sortBy
 * @param {object} object
 * @param {array<string>} sortBy
 * @returns {object}
 */
export const sortObjectKeys = (object, sortBy) => {
    const objectKeys = Object.keys(object);

    return (sortBy || []).concat(objectKeys.sort()).reduce((total, key) => {
        if (objectKeys.indexOf(key) !== -1) {
            total[key] = object[key];
        }

        return total;
    }, Object.create(null));
};
