/* eslint-disable camelcase */
import { parse } from 'date-fns';

export const normalizeAuthorInfo = (comments, authors) =>
    comments.reduce((info, comment) => {
        const authorId = `${comment.authorId}`;

        if (info[authorId]) return info;

        info[authorId] = authors.find((author) => author.id === authorId) || {
            id: authorId,
            public_name: authorId,
        };

        return info;
    }, {});

export const normalizeDate = (comments) =>
    comments.map((comment) => ({
        ...comment,
        created_at: parse(comment.created_at),
        lastBodyUpdate: parse(comment.lastBodyUpdate),
    }));
