﻿exports.Assignment = extend(
    DriveSBS.Assignment,
    function(options) {
        DriveSBS.Assignment.call(this, options);
    },
    {},
);

exports.Task = extend(
    DriveSBS.Task,
    function(options) {
        DriveSBS.Task.call(this, options);
    },
    {},
);

exports.TaskSuite = extend(
    DriveSBS.TaskSuite,
    function(options) {
        DriveSBS.TaskSuite.call(this, options);
    },
    {
        getFacts: function() {
            return {
                LOW_QUALITY_PASSPORT_BIOGRAPHICAL: 'Недостаточное качество фото в блоке "Паспорт: Лицевая"',
                LOW_QUALITY_SELFIE: 'Недостаточное качество фото в блоке "Селфи"',
                LOW_QUALITY_LICENSE_FRONT: 'Недостаточное качество фото в блоке "Права: Лицевая"',
                ANOTHER_PERSON: 'Другой человек',
                NOT_ORIGINAL: 'Не оригинал документа',
                SCREENCAP_SELFIE: 'Экранка селфи',
                WRONG_DOC: 'Не тот документ',
            };
        },

        getFactsOnRegistration: function () {
            return {
                triple_face_compare: {
                    SCREENCAP_SELFIE: 'Экранка селфи',
                    ANOTHER_PERSON: 'Другой человек',
                    NOT_ORIGINAL: 'Не оригинал / подделка документа',
                    WRONG_DOC: 'Не тот документ',
                    BAD_PHOTO: 'Недостаточное качество фото',
                },
            };
        },

        getProxyNames: function () {
            return {
                data: 'robot-yang-cars-registration-data',
                media: 'robot-yang-cars-registration',
            };
        },

        getSetStatusType: function () {
            return {
                passport_biographical: "passport_biographical_fill",
                passport_selfie: "passport_selfie_fill",
                license_front: "license_front_fill",
            };
        },
    },
);

function extend(ParentClass, constructorFunction, prototypeHash) {
    constructorFunction = constructorFunction || function() {};
    prototypeHash = prototypeHash || {};
    if (ParentClass) {
        constructorFunction.prototype = Object.create(ParentClass.prototype);
    }
    for (var i in prototypeHash) {
        constructorFunction.prototype[i] = prototypeHash[i];
    }
    return constructorFunction;
}
