﻿const path = require('path');
const fs = require('fs');

module.exports = {
    certPath: path.resolve(__dirname, './ssl/dev.pem'),
    project: {
        title: 'Ya.Drive: Facial SBS comparison',
        description: 'Toloka template for Drive facial sbs',
        instructions: 'TBD',
        hideSkip: true,
        markup: path.resolve(process.cwd(), './static/markup.hbs'),
        styles: path.resolve(process.cwd(), './static/styles.css'),
        script: path.resolve(process.cwd(), './static/script.js'),
        scriptUrls: ['https://local.yang.yandex-team.ru:3002/template-drive-face-sbs.js'],
        tasks: [
            {
                id: 0,
                input_values: {
                    secret: 'foo',
                    task_type: 'registration_on_chat',
                    document_types: ['passport_biographical', 'passport_selfie', 'license_front'],
                },
            },
        ],
        outputSpec: {
            general: {
                type: 'json',
                required: true,
                hidden: false,
            },
            other: {
                type: 'string',
                required: false,
                hidden: false,
            },
        },
        middleware: {
            before: [
                {
                    path: new RegExp('^/api/proxy/robot-yang-cars-registration-data/assignment/document_data?(.+)'),
                    handler: (req, res, next) => {
                        const documentType = req.query?.photo_type;
                        const filePath = path.resolve(__dirname, `./mocks/${documentType}.jpg`);

                        res.header('Cache-Control', 'private, no-cache, no-store, must-revalidate');
                        res.header('Expires', '-1');
                        res.header('Pragma', 'no-cache');

                        return fs.existsSync(filePath) ? res.end(fs.readFileSync(filePath)) : next();
                    },
                },
                {
                    path: new RegExp('^/api/proxy/robot-yang-cars-registration-data/assignment/user_info?(.+)'),
                    method: 'get',
                    handler: (req, res, next) => {
                        const filePath = path.resolve(__dirname, './mocks/document_rus.json');

                        return fs.existsSync(filePath) ? res.json(require(filePath)) : next();
                    },
                },
                {
                    path: new RegExp('^/api/proxy/robot-yang-cars-registration-data/assignment/queue?(.+)'),
                    method: 'post',
                    handler: (req, res, next) => {
                        res.writeHead(200, {
                            foo: 'bar',
                        });
                        return res.end();
                    },
                },
            ],
        },
    },
};
