const filename = require('./package.json').name;
const { CleanWebpackPlugin } = require('clean-webpack-plugin');
const AntdDayjsWebpackPlugin = require('antd-dayjs-webpack-plugin');
const WebpackBarPlugin = require('webpackbar');

const config = {
    output: {
        filename: `${filename}.js`,
        library: 'DriveSBS',
        libraryTarget: 'umd',
        umdNamedDefine: true,
    },
    module: {
        rules: [
            {
                test: /\.(js|jsx)$/,
                exclude: /node_modules/,
                resolve: {
                    extensions: ['.js', '.jsx'],
                },
                use: {
                    loader: 'babel-loader',
                    options: {
                        plugins: [
                            '@babel/plugin-syntax-dynamic-import',
                            [
                                'import',
                                {
                                    libraryName: 'antd',
                                    style: true,
                                    libraryDirectory: 'es',
                                },
                                'ant',
                            ],
                            [
                                'import',
                                {
                                    libraryName: '@ant-design/icons',
                                    customName: (name) => {
                                        const formatName = name
                                            .split('-')
                                            .reduce((acc, value) => acc + value[0].toUpperCase() + value.slice(1), '');

                                        return `@ant-design/icons/lib/icons/${formatName}`;
                                    },
                                },
                                '@ant-design/icons',
                            ],
                        ],
                    },
                },
            },
            {
                test: /\.css$/,
                use: ['style-loader', 'css-loader', 'csso-loader'],
            },
            {
                test: /\.less$/,
                use: [
                    'style-loader',
                    'css-loader',
                    'csso-loader',
                    {
                        loader: 'less-loader',
                        options: {
                            lessOptions: {
                                minimize: true,
                                javascriptEnabled: true,
                                modifyVars: {
                                    'primary-color': '#13c2c2',
                                    'link-color': '#13c2c2',
                                    'link-hover-color': '#5cdbd3',
                                    'processing-color': '#13c2c2',
                                    'tooltip-max-width': '400px',
                                },
                            }
                        },
                    },
                ],
            },
            {
                test: /\.(png|jpg|jpeg|gif|eot|ttf|woff|woff2|svg|svgz)(\?.+)?$/,
                use: [
                    {
                        loader: 'url-loader',
                        options: {
                            limit: 10000,
                        },
                    },
                ],
            },
        ],
    },
    plugins: [new CleanWebpackPlugin(), new AntdDayjsWebpackPlugin(), new WebpackBarPlugin()],
};

module.exports = config;
