﻿const { merge } = require('webpack-merge');
const common = require('./webpack.common.js');
const path = require('path');
const fs = require('fs');

const config = merge(common, {
    mode: 'development',
    devServer: {
        stats: 'errors-only',
        compress: true,
        disableHostCheck: true,
        https: {
            key: fs.readFileSync(path.resolve(__dirname, 'ssl', 'dev.pem')),
            cert: fs.readFileSync(path.resolve(__dirname, 'ssl', 'dev.pem')),
            ca: fs.readFileSync(path.resolve(__dirname, 'ssl', 'dev.pem')),
        },
        port: 3002,
        host: 'local.yang.yandex-team.ru',
    },
});

module.exports = config;
