﻿const TerserPlugin = require('terser-webpack-plugin');
const CompressionPlugin = require('compression-webpack-plugin');
const { merge } = require('webpack-merge');
const common = require('./webpack.common.js');

const config = merge(common, {
   mode: 'production',
	optimization: {
		namedModules: false,
		concatenateModules: true,
		minimize: true,
		minimizer: [
			new TerserPlugin({
				cache: false,
				parallel: true,
				terserOptions: {
					parse: {
						ecma: 8
					},
					ecma: 5,
					warnings: false,
					ie8: false
				}
	      })
		]
	},
		plugins: [
		new CompressionPlugin({
			filename: "[path].gz[query]",
			algorithm: "gzip",
			test: /\.js$|\.css$|\.html$/,
			threshold: 10240,
			minRatio: 0.75
		}),
	]
});

module.exports = config;
