import React from 'react';
import PropTypes from 'prop-types';
import { Checkbox, Form, Radio } from 'antd';
import { withHotkey } from '../Utility/WithHotkey';

const MAX_HOTKEYS = 9;

export const Criteria = ({ name, label, index, disabled, multipleSelect }) => {
    const criteriaIndex = index + 1;
    const hotKey = index < MAX_HOTKEYS ? { code: `Digit${criteriaIndex}`, label: criteriaIndex } : null;
    const InputComponent = multipleSelect ? withHotkey(Checkbox) : withHotkey(Radio);

    return (
        <Form.Item className="ant-form-item_compact" name={name} valuePropName="checked">
            <InputComponent hotKey={hotKey} disabled={disabled} multiple={multipleSelect}>
                {label}
            </InputComponent>
        </Form.Item>
    );
};

Criteria.propTypes = {
    name: PropTypes.string.isRequired,
    label: PropTypes.string.isRequired,
    index: PropTypes.number.isRequired,
    disabled: PropTypes.bool,
    multipleSelect: PropTypes.bool,
};
