import { setSolution } from '../../domain/store/actions/solution';
import { setTaskError } from '../../domain/store/actions/ui';
import { connect } from 'react-redux';
import { SidebarView } from './Sidebar';

const mapStateToProps = (state, ownProps) => {
    const { document } = ownProps;
    const { taskError, videoPlayed, videoError, scaleOptions } = state.ui;
    const { facts } = state.documents;

    return {
        facts: facts[document],
        taskError,
        videoPlayed: videoPlayed[document],
        videoError: videoError[document],
        scaleOptions,
        verdicts: state.solution.verdicts[document] || [],
    };
};

const mapDispatchToProps = (dispatch) => ({
    onSubmit: (values) => dispatch(setSolution(values)),
    resetTaskError: () => dispatch(setTaskError(null)),
});

export const Sidebar = connect(mapStateToProps, mapDispatchToProps)(SidebarView);
