import { connect } from 'react-redux';
import { SidebarHeaderView } from './SidebarHeader';
import { setActiveDocumentIdx } from '../../domain/store/actions/ui';

const mapStateToProps = (state) => {
    const { activeDocumentIndex } = state.ui;
    const { document_types: documentTypes } = state.input;

    return {
        activeDocumentIndex,
        availableDocuments: documentTypes.length,
    };
};

const mapDispatchToProps = (dispatch) => ({
    setActiveDocumentIndex: (val) => dispatch(setActiveDocumentIdx(val)),
});

export const SidebarHeader = connect(mapStateToProps, mapDispatchToProps)(SidebarHeaderView);
